// API route untuk anime
export default async function handler(req, res) {
  try {
    // Dapatkan path dari request
    const { path } = req.query;
    
    // Bangun URL API eksternal
    const ANIME_BASE_URL = process.env.ANIME_BASE_URL;
    const baseUrl = ANIME_BASE_URL.endsWith('/') ? ANIME_BASE_URL : `${ANIME_BASE_URL}/`;
    const apiUrl = `${baseUrl}${path.join('/')}`;
    
    // Dapatkan API key dari env
    const apiKey = process.env.API_KEY;
    
    // Buat options untuk fetch
    const options = {
      method: req.method,
      headers: {
        'Content-Type': 'application/json',
        'X-API-Key': apiKey,
      },
    };
    
    // Tambahkan body jika ada
    if (req.method !== 'GET' && req.body) {
      options.body = JSON.stringify(req.body);
    }
    
    // Fetch data dari API eksternal
    const response = await fetch(apiUrl, options);
    
    // Ambil data sebagai JSON
    const data = await response.json();
    
    // Kirim response ke client
    res.status(response.status).json(data);
  } catch (error) {
    // Tangani error
    console.error('Error in API route:', error);
    res.status(500).json({ error: 'Terjadi kesalahan pada server' });
  }
} 